/*******************************************************************************
  ShapesDemo
  Example submitted by David Clegg

  This demo program is designed to provide an introduction into drawing using
  the GDI+ classes in the .NET framework.
*******************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Drawing.Drawing2D; 

namespace ShapesDemo
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button btnClose;

		private Point fStartPoint;
		private Point fEndPoint;
		private Shape fShape;
		private bool fMouseDown;
		private Brush fCurrentBrush;

		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.GroupBox gbShape;
		private System.Windows.Forms.RadioButton rbRectangle;
		private System.Windows.Forms.RadioButton rbEllipse;
		private System.Windows.Forms.RadioButton rbTriangle;
		private System.Windows.Forms.ColorDialog cdFill;
		private System.Windows.Forms.RadioButton rbLine;
		private System.Windows.Forms.GroupBox gbBrush;
		private System.Windows.Forms.Button btnChooseBrush;
		private System.Windows.Forms.Panel pnBrush;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.gbBrush = new System.Windows.Forms.GroupBox();
			this.pnBrush = new System.Windows.Forms.Panel();
			this.btnChooseBrush = new System.Windows.Forms.Button();
			this.gbShape = new System.Windows.Forms.GroupBox();
			this.rbLine = new System.Windows.Forms.RadioButton();
			this.rbTriangle = new System.Windows.Forms.RadioButton();
			this.rbEllipse = new System.Windows.Forms.RadioButton();
			this.rbRectangle = new System.Windows.Forms.RadioButton();
			this.btnClose = new System.Windows.Forms.Button();
			this.btnClear = new System.Windows.Forms.Button();
			this.cdFill = new System.Windows.Forms.ColorDialog();
			this.panel1.SuspendLayout();
			this.gbBrush.SuspendLayout();
			this.gbShape.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.BackColor = System.Drawing.SystemColors.Control;
			this.panel1.Controls.Add(this.gbBrush);
			this.panel1.Controls.Add(this.gbShape);
			this.panel1.Controls.Add(this.btnClose);
			this.panel1.Controls.Add(this.btnClear);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Left;
			this.panel1.Location = new System.Drawing.Point(0, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(128, 442);
			this.panel1.TabIndex = 0;
			// 
			// gbBrush
			// 
			this.gbBrush.Controls.Add(this.pnBrush);
			this.gbBrush.Controls.Add(this.btnChooseBrush);
			this.gbBrush.Location = new System.Drawing.Point(8, 136);
			this.gbBrush.Name = "gbBrush";
			this.gbBrush.Size = new System.Drawing.Size(112, 48);
			this.gbBrush.TabIndex = 11;
			this.gbBrush.TabStop = false;
			this.gbBrush.Text = "Brush";
			this.gbBrush.Paint += new System.Windows.Forms.PaintEventHandler(this.gbBrush_Paint);
			// 
			// pnBrush
			// 
			this.pnBrush.BackColor = System.Drawing.Color.Red;
			this.pnBrush.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.pnBrush.ForeColor = System.Drawing.SystemColors.ControlText;
			this.pnBrush.Location = new System.Drawing.Point(8, 16);
			this.pnBrush.Name = "pnBrush";
			this.pnBrush.Size = new System.Drawing.Size(24, 24);
			this.pnBrush.TabIndex = 12;
			// 
			// btnChooseBrush
			// 
			this.btnChooseBrush.Location = new System.Drawing.Point(40, 16);
			this.btnChooseBrush.Name = "btnChooseBrush";
			this.btnChooseBrush.Size = new System.Drawing.Size(64, 23);
			this.btnChooseBrush.TabIndex = 11;
			this.btnChooseBrush.Text = "Choose...";
			this.btnChooseBrush.Click += new System.EventHandler(this.btnChooseBrush_Click);
			// 
			// gbShape
			// 
			this.gbShape.Controls.Add(this.rbLine);
			this.gbShape.Controls.Add(this.rbTriangle);
			this.gbShape.Controls.Add(this.rbEllipse);
			this.gbShape.Controls.Add(this.rbRectangle);
			this.gbShape.Location = new System.Drawing.Point(8, 8);
			this.gbShape.Name = "gbShape";
			this.gbShape.Size = new System.Drawing.Size(112, 120);
			this.gbShape.TabIndex = 6;
			this.gbShape.TabStop = false;
			this.gbShape.Text = "Shape";
			// 
			// rbLine
			// 
			this.rbLine.Location = new System.Drawing.Point(8, 88);
			this.rbLine.Name = "rbLine";
			this.rbLine.Size = new System.Drawing.Size(80, 24);
			this.rbLine.TabIndex = 3;
			this.rbLine.Text = "Line";
			// 
			// rbTriangle
			// 
			this.rbTriangle.Location = new System.Drawing.Point(8, 64);
			this.rbTriangle.Name = "rbTriangle";
			this.rbTriangle.Size = new System.Drawing.Size(80, 24);
			this.rbTriangle.TabIndex = 2;
			this.rbTriangle.Text = "Triangle";
			// 
			// rbEllipse
			// 
			this.rbEllipse.Location = new System.Drawing.Point(8, 40);
			this.rbEllipse.Name = "rbEllipse";
			this.rbEllipse.Size = new System.Drawing.Size(80, 24);
			this.rbEllipse.TabIndex = 1;
			this.rbEllipse.Text = "Ellipse";
			// 
			// rbRectangle
			// 
			this.rbRectangle.Checked = true;
			this.rbRectangle.Location = new System.Drawing.Point(8, 16);
			this.rbRectangle.Name = "rbRectangle";
			this.rbRectangle.Size = new System.Drawing.Size(80, 24);
			this.rbRectangle.TabIndex = 0;
			this.rbRectangle.TabStop = true;
			this.rbRectangle.Text = "Rectangle";
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.btnClose.Location = new System.Drawing.Point(24, 400);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 5;
			this.btnClose.Text = "Close";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.btnClear.Location = new System.Drawing.Point(24, 360);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 4;
			this.btnClear.Text = "Clear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Window;
			this.ClientSize = new System.Drawing.Size(640, 442);
			this.Controls.Add(this.panel1);
			this.Name = "MainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Shapes Demo";
			this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseDown);
			this.MouseUp += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseUp);
			this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseMove);
			this.panel1.ResumeLayout(false);
			this.gbBrush.ResumeLayout(false);
			this.gbShape.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new MainForm());
		}

		private void btnClose_Click(object sender, System.EventArgs e) {
			Close();
		}

		/// <summary>
		/// Save the starting point for reference when drawing the shape outline,
		/// and filling the shape in its final position on the MouseUp event.
		/// </summary>
		private void MainForm_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e) {
			fShape = GetShape();
			fStartPoint = new Point(e.X, e.Y);
			fMouseDown = true;
		}

		/// <summary>
		/// Determine which shape we should be drawing.
		/// </summary>
		private Shape GetShape() {
			if (rbEllipse.Checked)
				return new Ellipse(this.CreateGraphics());
			else if (rbTriangle.Checked)
				return new Triangle(this.CreateGraphics());
			else if (rbRectangle.Checked)
				return new Rectangle(this.CreateGraphics());
			else if (rbLine.Checked)
				return new Line(this.CreateGraphics());
			else
				return null;
		}

		/// <summary>
		/// Fill the shape using the selected brush.
		/// </summary>
		private void MainForm_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e) {
			if (fShape != null) {
				fEndPoint = new Point(e.X, e.Y);
				if ((fEndPoint.X == fStartPoint.X) && (fEndPoint.Y == fStartPoint.Y)) {
					//If the user clicks without dragging, default the size of
					//the shape.
					fEndPoint.X = fEndPoint.X + 50;
					fEndPoint.Y = fEndPoint.Y + 50;
				}
				Brush lBrush = GetBrush();
				fShape.Draw(fStartPoint, fEndPoint, lBrush);
				fShape.Dispose();
			}
			fMouseDown = false;
		}

		/// <summary>
		/// Determine which brush we should be using when filling the shape.
		/// </summary>
		private Brush GetBrush() {
			Brush lRetVal;
			if (fCurrentBrush != null)
				lRetVal = fCurrentBrush;
			else
				lRetVal = new SolidBrush(pnBrush.BackColor);

			//Need to transform the gradient brush to fit the shape. I believe
			//this can be done by using LinearGradientBrush.ScaleTransform, but
			//I have been unable to get that to successfully work. So for now,
			//I will simply re-create the brush using the bounding rectangle for
			//the shape.
			if (lRetVal is LinearGradientBrush)
				//Get a reference to the current brush
				lRetVal = ResizeLinearGradientBrush(System.Drawing.Rectangle.FromLTRB(
													fStartPoint.X, fStartPoint.Y,
													fEndPoint.X, fEndPoint.Y),
													(LinearGradientBrush)lRetVal);
			return lRetVal;
		}

		/// <summary>
		/// Resizes the specified LinearGradientBrush to ensure the gradient
		/// fits in the specified rectangle.
		/// </summary>
		private LinearGradientBrush ResizeLinearGradientBrush(System.Drawing.Rectangle rect,
			LinearGradientBrush brush) {
			return new LinearGradientBrush(rect, brush.LinearColors[0], brush.LinearColors[1],
										   LinearGradientMode.Vertical);
		}

		/// <summary>
		/// Draw the outline for the shape, to indicate where the shape will be
		/// rendered when the mouse button is released.
		/// </summary>
		private void MainForm_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e) {
			if ((fShape != null) && fMouseDown)
				fShape.DrawOutline(fStartPoint, new Point(e.X, e.Y));
		}

		private void btnClear_Click(object sender, System.EventArgs e) {
			Graphics canvas = this.CreateGraphics();
			try {
				canvas.Clear(this.BackColor);
			}
			finally {
				//The Graphics reference must be disposed once we are finished
				//with it
				canvas.Dispose();
			}
		}

		/// <summary>
		/// Paint the Brush panel to reflect the currently selected brush.
		/// </summary>
		private void UpdateBrushPanel() {
			if (fCurrentBrush != null) {
				Brush lBrush;
				//Ensure that the gradient is properly resized if the brush is a
				//LinearGradientBrush
				if (fCurrentBrush is LinearGradientBrush)
					lBrush = ResizeLinearGradientBrush(pnBrush.ClientRectangle,
													   (LinearGradientBrush)fCurrentBrush);
				else
				  lBrush = fCurrentBrush;
				Graphics lGraphics = pnBrush.CreateGraphics();
				try {
					lGraphics.FillRectangle(lBrush, pnBrush.ClientRectangle);
				}
				finally {
					//The Graphics reference must be disposed once we are
					//finished with it
					lGraphics.Dispose();
				}
			}
		}

		private void btnChooseBrush_Click(object sender, System.EventArgs e) {
			BrushForm.Brush = fCurrentBrush;
			if (BrushForm.ShowBrushForm() == DialogResult.OK) {
				fCurrentBrush = BrushForm.Brush;
				UpdateBrushPanel();
			}
		}

		private void gbBrush_Paint(object sender, System.Windows.Forms.PaintEventArgs e) {
			UpdateBrushPanel();
		}

	}
}
